﻿using UnityEngine;
using System.Collections;

public class LVL2_Door : StoryEvent
{
    public int m_Way;
    public Door m_Door;
    public Transform m_Target;

    public override bool Initialize()
    {
        return m_Door.DiodeAlreadySwitchOn(m_Way - 1);
    }

    public override void StartStory()
    {
        base.StartStory();
        StartCoroutine("C_ActiveDiode");
    }

    private IEnumerator C_ActiveDiode()
    {
        GameManager.Instance.PlayerCanMove = false;
        CameraManager.Instance.SetStoryMove(m_Target.position, m_Target.rotation, 1f, 1f);
        yield return new WaitForSeconds(1.5f);
        if (m_Door.SwitchDiodesOn(m_Way))
        {
            // Wait for door opening animation
            CameraManager.Instance.StayMoreTimeInStoryMove(1f);
            yield return new WaitForSeconds(1f);
        }
        yield return new WaitForSeconds(1.5f);
        GameManager.Instance.PlayerCanMove = true;
        m_Finished = true;
    }
}